<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('hogwords_cf7_theme_setup9')) {
	add_action( 'after_setup_theme', 'hogwords_cf7_theme_setup9', 9 );
	function hogwords_cf7_theme_setup9() {
		if (is_admin()) {
			add_filter( 'hogwords_filter_tgmpa_required_plugins',		'hogwords_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'hogwords_cf7_tgmpa_required_plugins' ) ) {
	
	function hogwords_cf7_tgmpa_required_plugins($list=array()) {
		if (hogwords_storage_isset('required_plugins', 'contact-form-7')) {
			$list[] = array(
					'name' 		=> hogwords_storage_get_array('required_plugins', 'contact-form-7'),
					'slug' 		=> 'contact-form-7',
					'required' 	=> false
				);
		}
		return $list;
	}
}



// Check if Instagram Feed installed and activated
if ( !function_exists( 'hogwords_exists_cf7' ) ) {
	function hogwords_exists_cf7() {
		return defined('WPCF7');
	}
}
?>